﻿

/****** Object:  StoredProcedure [dbo].[CombineDocs]    Script Date: 31/07/2022 10:39:21 ق.ظ ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

CREATE PROCEDURE [dbo].[CombineDocs]
	(
		@IDFrom bigint=0,
		@IDTo bigint=0,
		@ReturnValue bit=0
	)
AS
	SET NOCOUNT ON 

	if @IDFrom = 0 OR @IDTo = 0 or @IDFrom = @IDTo 
		if @ReturnValue = 1
			return 0
		else
		BEGIN
			select 0
			return 
		END

	BEGIN transaction

	DECLARE @MaxRelationID as bigint

	Insert into SmallLists(Type, Title, OrderBy, Description) values(999999, '[CombineDocs]'+Str(@IDFrom)+Str(@IDTo), 0, '')

	Select @MaxRelationID=coalesce(max(RelationID),0) from AccDocItem where HeaderID=@IDTo 
	
	update AccChequeIn set DocItemRelationID=DocItemRelationID+@MaxRelationID+1 
		where DocItemID in (select ID from AccDocItem where HeaderID=@IDFrom)
	update AccChequeIn set CashItemRelationID=CashItemRelationID+@MaxRelationID+1 
		where CashDocItemID in (select ID from AccDocItem where HeaderID=@IDFrom)
	update AccChequeInTemp set DocItemRelationID=DocItemRelationID+@MaxRelationID+1 
		where DocItemID in (select ID from AccDocItem where HeaderID=@IDFrom)
	update AccChequeInTemp set CashItemRelationID=CashItemRelationID+@MaxRelationID+1 
		where CashDocItemID in (select ID from AccDocItem where HeaderID=@IDFrom)

	update AccChequeOut set DocItemRelationID=DocItemRelationID+@MaxRelationID+1 
		where DocItemID in (select ID from AccDocItem where HeaderID=@IDFrom)
	update AccChequeOutTemp  set DocItemRelationID=DocItemRelationID+@MaxRelationID+1 
		where DocItemID in (select ID from AccDocItem where HeaderID=@IDFrom)
	update AccChequeOutItemInfo set CashDocItemRelationID=CashDocItemRelationID+@MaxRelationID+1 
		where CashDocItemID in (select ID from AccDocItem where HeaderID=@IDFrom)
	update AccChequeOutItemInfoTemp set CashDocItemRelationID=CashDocItemRelationID+@MaxRelationID+1 
		where CashDocItemID in (select ID from AccDocItem where HeaderID=@IDFrom)

	update AccDocAttach set DocHeaderID = @IDTo where DocHeaderID=@IDFrom 

	update AccFactorDetail set DocHeaderID = @IDTo where DocHeaderID=@IDFrom 
	update AccFactorDetail set DocItemRelationID=DocItemRelationID+@MaxRelationID+1 
		where DocItemID in (select ID from AccDocItem where HeaderID=@IDFrom)
	update AccFactorPay set DocHeaderID = @IDTo where DocHeaderID=@IDFrom 


	update AccSellFactor set DocItemRelationID=DocItemRelationID+@MaxRelationID+1 
		where DocItemID in (select ID from AccDocItem where HeaderID=@IDFrom)
	update AccSellFactorTemp set DocItemRelationID=DocItemRelationID+@MaxRelationID+1 
		where DocItemID in (select ID from AccDocItem where HeaderID=@IDFrom)

	update AccSellFactorTrucks set DocHeaderID = @IDTo where DocHeaderID=@IDFrom 
	update AccSellFactorTrucks set DocItemRelationID=DocItemRelationID+@MaxRelationID+1 
		where DocItemID in (select ID from AccDocItem where HeaderID=@IDFrom)

	update AccSellFactorTrucksTemp set DocHeaderID = @IDTo where DocHeaderID=@IDFrom 
	update AccSellFactorTrucksTemp set DocItemRelationID=DocItemRelationID+@MaxRelationID+1 
		where DocItemID in (select ID from AccDocItem where HeaderID=@IDFrom)

	update AccWarehouse set TakhfifDocHeaderID = @IDTo where TakhfifDocHeaderID=@IDFrom 
	update AccWarehouse set HamlDocHeaderID = @IDTo where HamlDocHeaderID=@IDFrom 
	update AccWarehouseDetails set DocHeaderID = @IDTo where DocHeaderID=@IDFrom 

	update AccDocItem set RelationID = coalesce(RelationID,0)+@MaxRelationID where HeaderID=@IDFrom and RelationID > 0
	DECLARE @MaxOrder as int
	SELECT @MaxOrder = coalesce(max(ShowOrder),0) from AccDocItem where HeaderID=@IDTo  
	update AccDocItem set ShowOrder = ShowOrder+@MaxOrder+1 where HeaderID=@IDFrom and RelationID > 0
	update AccDocItem set HeaderID = @IDTo where HeaderID=@IDFrom 
	update AccDocItemTemp set HeaderID = @IDTo where HeaderID=@IDFrom 

	delete from AccDocHeader where id=@IDFrom 

	COMMIT transaction

	if @ReturnValue = 1
		return 1
	else
	BEGIN
		select 1
		return 
	END
GO


